﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class MainMenu : MonoBehaviour
{
    public AudioClip MenuMusicClip;

    public void Start()
    {
        //Starting, so let's set up and begin the audio and navigate to the Main Menu
        AudioManager.Instance.SetMusicVolume(Convert.ToSingle(SettingsManager.Instance.Settings[Constants.Settings.MusicVolume]));
        AudioManager.Instance.SetSFXVolume(Convert.ToSingle(SettingsManager.Instance.Settings[Constants.Settings.SFXVolume]));

        AudioManager.Instance.PlayMusic(MenuMusicClip);
        PageManager.NavigateForward(gameObject.GetComponent<PageDefinition>());
    }

    public void Awake()
    {
        AudioManager.Instance.SetMusicVolume(Convert.ToSingle(SettingsManager.Instance.Settings[Constants.Settings.MusicVolume]));
        AudioManager.Instance.SetSFXVolume(Convert.ToSingle(SettingsManager.Instance.Settings[Constants.Settings.SFXVolume]));
    }

    public async void QuitGame()
    {
        int button = await MessageBoxManager.Instance.Show("Quit Game?", "Are you sure you want to quit the game and return to Windows?", new List<string>() { "No, don't quit", "Yes, quit" });
        if(button == 1)
        {
            //User pressed Yes, so quit
            Application.Quit();
        }
    }
}
